// CREACION DE LAS TABLAS
var TablaArticulos = "CREATE TABLE IF NOT EXISTS ARTICULOS (ARTI_COD TEXT PRIMARY KEY, ARTI_DESC TEXT, GRUP_COD TEXT, SUBG_COD TEXT, MARC_COD TEXT, ARTI_UNIDAD TEXT, ARTI_TAIV NUMERIC, ARTI_CONSUMO NUMERIC, ARTI_EXISTE NUMERIC, ARTI_PRECIO NUMERIC)";
var TablaClientes = "CREATE TABLE IF NOT EXISTS CLIENTES (TERC_NIT TEXT PRIMARY KEY, TERC_NOM TEXT, LIPR_COD INTEGER)";
var TablaAcceso = "CREATE TABLE IF NOT EXISTS ACCESO (USU_COD TEXT PRIMARY KEY, VEND_COD INTEGER, FECHA_ING DATE, VEND_NOM TEXT, ACT_ARTI DATE, ACT_CLIE DATE, ACT_CART DATE, ACT_UND DATE, ACT_LIPR DATE)";
var TablaPedidoWeb = "CREATE TABLE IF NOT EXISTS PEDIDO_WEB (PEWE_ID INTEGER PRIMARY KEY AUTOINCREMENT, PEWE_FECHA DATE, TERC_NIT TEXT, PEWE_SUCURSAL TEXT, PEWE_OBS BLOB, PEWE_ENTREGA DATE, VEND_COD INTEGER, PEWE_DTOPORC NUMERIC, PEWE_ADICIONAL NUMERIC, PEWE_EXTRA NUMERIC, PEWE_IVAMONTO NUMERIC, PEWE_TOTAL NUMERIC, PEWE_RTFTEPORC NUMERIC, PEWE_RTIVAPORC NUMERIC, PEWE_RTICAPORC NUMERIC, PEWE_PREF TEXT, PEWE_DTOMONTO NUMERIC, PEWE_NUMPED TEXT, PEWE_IDPED INTEGER, PEWE_NOMCLI TEXT, PTVT_ID INTEGER, PEWE_OK TEXT, PEWE_ENVIO TEXT)";
var TablaPedidoWebDetalle = "CREATE TABLE IF NOT EXISTS PEDIDO_WEB_DETALLE (PEWE_ID INTEGER, PEWD_ITEM INTEGER, ARTI_COD TEXT, PEWD_CODBAR TEXT, BODE_COD TEXT, PEWD_CANT NUMERIC, PEWD_UNIDAD TEXT, PEWD_FACTOR NUMERIC, LIPR_COD INTEGER, PEWD_PRUNIT NUMERIC, PEWD_DTOP NUMERIC, PEWD_DTO1 NUMERIC, PEWD_DTO2 NUMERIC, PEWD_DTO3 NUMERIC, PEWD_IVAP NUMERIC, PEWD_IVAMONTO NUMERIC, PEWD_CONSUMO NUMERIC, PEWD_TOTAL, PEWD_REFERENCIA TEXT, PEWD_DTOM NUMERIC, PEWD_DTO1M NUMERIC, PEWD_DTO2M NUMERIC, PEWD_DTO3M NUMERIC, PEWD_DESC, PEWD_ANULADO)";
var TablaPreciosArti = "CREATE TABLE  IF NOT EXISTS PRECIOS_ARTICULO (LIPR_COD INTEGER, ARTI_COD TEXT, PRAR_FIJO NUMERIC, LIPR_NOM TEXT, PRAR_DTO1 NUMERIC, PRAR_DTO2 NUMERIC, PRAR_DTO3 NUMERIC)";
var TablaUnidadArti = "CREATE TABLE IF NOT EXISTS UNIDAD_ARTICULO (ARTI_COD TEXT, UNAR_UNIDAD TEXT, UNAR_FACCANT NUMERIC, UNAR_FACPRE NUMERIC)";
var TablaCarteraCli = "CREATE TABLE IF NOT EXISTS CARTERA_CLIENTE (TERC_NIT TEXT, TERC_NOM TEXT, IDDOC INTEGER, PREFDOC TEXT, NUMDOC TEXT, CONCEPTO TEXT, MONTO NUMERIC, SALDO NUMERIC, TIPONOM TEXT, FECDOC DATE, VENCE TEXT, DIAS INTEGER)";
// UNIDADES Y LISTAS
var unidadesArti = "SELECT UNAR_UNIDAD, UNAR_FACCANT FROM UNIDAD_ARTICULO WHERE ARTI_COD = ?";
var listasPrecios = "SELECT LIPR_COD, LIPR_NOM FROM PRECIOS_ARTICULO WHERE ARTI_COD = ?";
var listaPreEnca = "SELECT DISTINCT LIPR_COD, LIPR_NOM FROM PRECIOS_ARTICULO";
var preciolista =  "SELECT PRAR_FIJO FROM PRECIOS_ARTICULO WHERE LIPR_COD = ? AND ARTI_COD = ?";
// PEDIDO_WEB ENCABEZADO
var insertEncabezado = "INSERT INTO PEDIDO_WEB (VEND_COD, TERC_NIT, PEWE_SUCURSAL, PEWE_FECHA, PEWE_ENTREGA, PEWE_NOMCLI, PEWE_OBS, PEWE_OK, PEWE_ENVIO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
var updateEncabezado = "UPDATE PEDIDO_WEB SET VEND_COD = ?, TERC_NIT = ?, PEWE_SUCURSAL = ?, PEWE_FECHA = ?, PEWE_ENTREGA = ?, PEWE_NOMCLI = ? , PEWE_OBS = ?, PEWE_OK = 'N', PEWE_ENVIO = 'N' WHERE PEWE_ID = ?";
var finPedido = "UPDATE PEDIDO_WEB SET PEWE_OK = 'S', PEWE_ENVIO = 'N', PEWE_TOTAL = ? WHERE PEWE_ID = ?";
var encapedall = "SELECT PEWE_ID, TERC_NIT, VEND_COD, PEWE_IVAMONTO, PEWE_TOTAL, PEWE_FECHA, PEWE_NOMCLI, PEWE_OK, PEWE_ENVIO FROM PEDIDO_WEB";
var actVendEnca = "UPDATE PEDIDO_WEB SET VEND_COD = ?";
//var totdtos = "SELECT SUM(PEWD_DTO1M) DTO1M, SUM(PEWD_DTO2M) DTO2M FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ?"
var selectIdPedweb = "SELECT MAX(PEWE_ID) ID FROM PEDIDO_WEB";
var updateEnvio = "UPDATE PEDIDO_WEB SET PEWE_ENVIO = 'S' WHERE PEWE_ID = ?";
var updateEnvios = "UPDATE PEDIDO_WEB SET PEWE_ENVIO = 'N' WHERE PEWE_ID = ?";
var pedidosDia = "SELECT PEWE_ID, TERC_NIT, PEWE_SUCURSAL, PEWE_NOMCLI, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_FECHA = ? AND PEWE_OK = 'S'";
var recuperarPedidos = "SELECT PEWE_ID, TERC_NIT, PEWE_NOMCLI, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_FECHA = ? AND PEWE_OK = 'N'";
var traePedRecu = "SELECT TERC_NIT, PEWE_SUCURSAL, PEWE_NOMCLI, PEWE_ENTREGA, PEWE_OBS, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_ID = ?";
var pedxEnviar = "SELECT PEWE_ID, PEWE_FECHA, TERC_NIT, PEWE_NOMCLI, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_OK = 'S' AND PEWE_ENVIO = 'N'";
var borrEncaEnv = "DELETE FROM PEDIDO_WEB WHERE PEWE_ID = ?";
var pedEnviados = "SELECT PEWE_ID, PEWE_FECHA, TERC_NIT, PEWE_NOMCLI, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_OK = 'S' AND PEWE_ENVIO = 'S'";
var enviarEncabezado = "SELECT PEWE_ID, VEND_COD, TERC_NIT, PEWE_SUCURSAL, PEWE_FECHA, PEWE_ENTREGA, PEWE_NOMCLI, PEWE_OBS, PEWE_DTOPORC, PEWE_ADICIONAL, PEWE_EXTRA, PEWE_RTFTEPORC, PEWE_RTIVAPORC, PEWE_RTICAPORC, PEWE_IVAMONTO, PEWE_TOTAL FROM PEDIDO_WEB WHERE PEWE_ID = ?";
// PEDIDO_WEB_DETALLE
var detall = "SELECT PEWD_ITEM, PEWD_CODBAR, PEWD_CANT, PEWD_UNIDAD, PEWD_UNIDAD, PEWD_FACTOR, LIPR_COD, PEWD_PRUNIT, PEWD_DTO1, PEWD_DTO2, PEWD_DTO3, PEWD_IVAP, PEWD_IVAMONTO, PEWD_TOTAL, PEWD_DTO1M, PEWD_DTO2M, PEWD_DTO3M, PEWD_DESC, PEWD_ANULADO FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ?";
var insertDetalle = "INSERT INTO PEDIDO_WEB_DETALLE (PEWE_ID, PEWD_ITEM, PEWD_CODBAR, PEWD_CANT, PEWD_PRUNIT, PEWD_REFERENCIA, PEWD_UNIDAD, PEWD_TOTAL, PEWD_DESC, LIPR_COD, PEWD_FACTOR, PEWD_ANULADO, PEWD_DTO1, PEWD_DTO2, PEWD_DTO3, PEWD_DTO1M, PEWD_DTO2M, PEWD_DTO3M, PEWD_IVAP, PEWD_IVAMONTO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'N', ?, ?, ?, ?, ?, ?, ?, ?)";
var verArtiPed = "SELECT PEWD_CODBAR, PEWD_DESC, PEWD_CANT, PEWD_PRUNIT, PEWD_TOTAL, PEWD_ITEM FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ? AND PEWD_ANULADO = 'N'";
var numitems = "SELECT COUNT(PEWD_ITEM) ITEMS, SUM(PEWD_TOTAL) TOTAL FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ? AND PEWD_ANULADO = 'N'";
var borrarArtiDeta = "DELETE FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ? AND PEWD_ITEM = ?";
var borrarArtiDet = "UPDATE PEDIDO_WEB_DETALLE SET PEWD_ANULADO = 'S' WHERE PEWE_ID = ? AND PEWD_ITEM = ?";
var borrDetEnvi = "DELETE FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ?";
var enviarDetalle = "SELECT PEWE_ID, PEWD_ITEM, PEWD_CODBAR, PEWD_CANT, PEWD_PRUNIT, PEWD_REFERENCIA, PEWD_UNIDAD, PEWD_TOTAL, PEWD_DESC, LIPR_COD, PEWD_FACTOR, PEWD_DTO1, PEWD_DTO2, PEWD_DTO3, PEWD_DTO1M, PEWD_DTO2M, PEWD_DTO3M, PEWD_IVAP, PEWD_IVAMONTO FROM PEDIDO_WEB_DETALLE WHERE PEWE_ID = ? AND PEWD_ANULADO = 'N'";
// CARGAR DATOS LOCALES
var insertlistapre = "INSERT INTO PRECIOS_ARTICULO (LIPR_COD, ARTI_COD, PRAR_FIJO, LIPR_NOM, PRAR_DTO1, PRAR_DTO2, PRAR_DTO3) VALUES (?, ?, ?, ?, ?, ?, ?)";
var insertUnidades = "INSERT INTO UNIDAD_ARTICULO (ARTI_COD, UNAR_UNIDAD, UNAR_FACCANT, UNAR_FACPRE) VALUES (?, ?, ?, ?)";
var insertcartclie = "INSERT INTO CARTERA_CLIENTE (TERC_NIT, TERC_NOM, IDDOC, PREFDOC, NUMDOC, CONCEPTO, MONTO, SALDO, TIPONOM, FECDOC, VENCE, DIAS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
var insertAcceso = "INSERT INTO ACCESO (USU_COD, VEND_COD, VEND_NOM, FECHA_ING) VALUES (?, ?, ?, ?)"; 
var insertArticulos = "INSERT INTO ARTICULOS (ARTI_COD, ARTI_DESC, GRUP_COD, SUBG_COD, MARC_COD, ARTI_UNIDAD, ARTI_TAIV, ARTI_CONSUMO, ARTI_EXISTE, ARTI_PRECIO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ? ,?)";
var insertClientes = "INSERT INTO CLIENTES (TERC_NIT, TERC_NOM, LIPR_COD) VALUES (?, ?, ?)";
// BORRAR DATOS LOCALES
var borrarPreciosAll = "DELETE FROM PRECIOS_ARTICULO";
var borrarUnidadesAll = "DELETE FROM UNIDAD_ARTICULO";
var borrarCarteraAll = "DELETE FROM CARTERA_CLIENTE";
var borrarArtiAll = "DELETE FROM ARTICULOS";
var borrarClientesAll = "DELETE FROM CLIENTES";
// BUSQUEDA CLIENTES Y ARTICULOS
var carteracliente = "SELECT * FROM CARTERA_CLIENTE WHERE TERC_NIT = ?";
var nomCli = "SELECT TERC_NOM, LIPR_COD FROM CLIENTES WHERE TERC_NIT = ?";
var buscaClientes = "SELECT TERC_NIT, TERC_NOM FROM CLIENTES WHERE UPPER(TERC_NOM) LIKE UPPER('%' || ? || '%')";
var buscaArtiCod = "SELECT * FROM ARTICULOS WHERE UPPER(ARTI_COD) LIKE UPPER('%' || ? || '%')";
var buscaArtiDesc = "SELECT * FROM ARTICULOS WHERE UPPER(ARTI_DESC) LIKE UPPER('%' || ? || '%')";
var artiNombre = "SELECT ARTI_DESC, ARTI_UNIDAD, ARTI_PRECIO, ARTI_EXISTE, ARTI_TAIV FROM ARTICULOS WHERE ARTI_COD = ?";
var descuentos = "SELECT PRAR_DTO1, PRAR_DTO2, PRAR_DTO3 FROM PRECIOS_ARTICULO WHERE ARTI_COD = ? AND LIPR_COD = ?"
var exist = "SELECT ARTI_EXISTE FROM ARTICULOS WHERE ARTI_COD = ?";
//var reservado = "SELECT SUM(PEWD_CANT) AS 'RESERVA' FROM PEDIDO_WEB_DETALLE AS PD, PEDIDO_WEB AS P WHERE PD.ARTI_COD = ? AND P.PEWE_FECHA >= ?";
// ACCESO
var selecFechasAct = "SELECT ACT_ARTI, ACT_CLIE, ACT_CART, ACT_UND, ACT_LIPR FROM ACCESO";
var selectUltAcceso = "SELECT FECHA_ING, USU_COD, VEND_COD, VEND_NOM FROM ACCESO WHERE USU_COD = ?";
var updateAcceso = "UPDATE ACCESO SET FECHA_ING = ? WHERE USU_COD = ?";
var updateActArti = "UPDATE ACCESO SET ACT_ARTI = ?";
var updateActCli = "UPDATE ACCESO SET ACT_CLIE = ?";
var updateActCart = "UPDATE ACCESO SET ACT_CART = ?";
var updateActUnd = "UPDATE ACCESO SET ACT_UND = ?";
var updateActLipr = "UPDATE ACCESO SET ACT_LIPR = ?";
var updateDelCat = "UPDATE ACCESO SET ACT_ARTI = '', ACT_CLIE = '', ACT_CART = '', ACT_UND = '', ACT_LIPR = ''";
// INICIALIZAR BD
var StatementPragma = "PRAGMA synchronous=3";
var tam = 1024 * 1024 * 80;
var db = openDatabase("SYSPLUS", "1.0", "SYSPLUSBD", tam);  // Open SQLite Database
var dataset;
var DataType;
// Function Call When Page is ready. 
function initDatabase() {
    try {
        if (!window.openDatabase)  // Check browser is supported SQLite or not.
        {
            alert('Databases are not supported in this browser.');
        }else {
            createTable();  // If supported then call Function for create table in SQLite
        }
    }
    catch (e) { 
        if (e == 2) {
            // Version number mismatch. 
            console.log("Invalid database version.");
        }else {
            console.log("Unknown error " + e + ".");
        }
        return;
    }
}
// Function for Create Table in SQLite. 
function createTable(){
    db.transaction(function (tx) { 
		tx.executeSql(TablaArticulos, [], showRecords, onError);
		tx.executeSql(TablaClientes, [], showRecords, onError);
		tx.executeSql(TablaAcceso, [], showRecords, onError);
		tx.executeSql(TablaPedidoWeb, [], showRecords, onError);
		tx.executeSql(TablaPedidoWebDetalle, [], showRecords, onError);
		tx.executeSql(TablaPreciosArti, [], showRecords, onError);
		tx.executeSql(TablaUnidadArti, [], showRecords, onError);
		tx.executeSql(TablaCarteraCli, [], showRecords, onError);
		});
}
//Function for Load and Reset...
function loadAndReset() {
	//alert('Transaccion exitosa');
}
// Function for Hendeling Error... 
function onError(tx, error) {
    alert('Se ha presentado el siguiente error: ' + error.message);
}
// Function For Retrive data from Database Display records as list
function showRecords() {
    $("#results").html('')
    db.transaction(function (tx) {
        tx.executeSql(buscaArtiCod, [], function (tx, result) {
            dataset = result.rows;
            for (var i = 0, item = null; i < dataset.length; i++) {
                item = dataset.item(i);
                var linkeditdelete = '<li>' + item['ARTI_COD'] + ' , ' + item['ARTI_DESC'] + '    ' + '<a href="#" onclick="loadRecord(' + i + ');">edit</a>' + '    ' +
                                            '<a href="#" onclick="deleteRecord(' + item['id'] + ');">delete</a></li>';
                $("#results").append(linkeditdelete);
            }
        });
    });
}
// Call function when page is ready for load..
$(document).ready(function (){
;
	initDatabase();
});